import {Component, Input, OnInit} from '@angular/core';
import {StockService} from '../../services/stock.service';
import {Stock} from '../../models/stock';

@Component({
  selector: 'kro-stock-list',
  templateUrl: './stock-list.component.html',
  styleUrls: ['./stock-list.component.scss']
})
export class StockListComponent implements OnInit {
  @Input()
  limit: number = Infinity;

  @Input('full')
  isFullInfo: boolean = true;

  companies: Stock[] = undefined;
  header: string = undefined;

  constructor(private stockService: StockService) { }

  ngOnInit() {
    this.stockService.get().subscribe(data => {
      this.companies = data;
      if (!this.isFullInfo) {
        this.companies = this.companies.slice(0, this.limit);
      }
    });
    this.stockService.meta.subscribe(header => {
      this.header = header;
    });
  }

}
