import {JsonObject, JsonProperty} from 'json2typescript';

@JsonObject
export class Coin {
  @JsonProperty('name', String)
  private _name: string = undefined;

  @JsonProperty('code', String)
  private _code: string = undefined;

  @JsonProperty('circulation', Number)
  private _circulation: number = undefined;

  @JsonProperty('price', Number)
  private _price: number = undefined;

  @JsonProperty('market', Number)
  private _market: number = undefined;


  get market(): number {
    return this._market;
  }

  set market(value: number) {
    this._market = value;
  }

  get name(): string {
    return this._name;
  }

  set name(value: string) {
    this._name = value;
  }

  get code(): string {
    return this._code;
  }

  set code(value: string) {
    this._code = value;
  }

  get circulation(): number {
    return this._circulation;
  }

  set circulation(value: number) {
    this._circulation = value;
  }

  get price(): number {
    return this._price;
  }

  set price(value: number) {
    this._price = value;
  }
}
