import tornado.web
from web_scrapper import CryptoScrapper, CurrencyScrapper, StockScrapper

SERVER_ADDRESS = 'localhost'
SERVER_PORT    = '8888'

DATA = {}
INTERVAL = 30


class BaseHandler(tornado.web.RequestHandler):
    def data_received(self, chunk):
        pass

    def set_default_headers(self):
        self.set_header("Access-Control-Allow-Origin", "*")
        self.set_header("Access-Control-Allow-Headers", "Content-Type, Accept,X-Requested-With")
        self.set_header('Access-Control-Allow-Methods', 'POST, GET, OPTIONS')

    def options(self):
        self.set_status(204)
        self.finish()


class StockHandler(BaseHandler):
    def get(self):
        global DATA
        self.write(DATA['stock'])


class CryptoHandler(BaseHandler):
    def get(self):
        global DATA
        self.write(DATA['crypto'])


class CurrencyHandler(BaseHandler):
    def get(self):
        global DATA
        self.write(DATA['currency'])


def refresh_data():
    get_stock()
    get_currency()
    get_crypto()


def get_stock():
    global DATA
    scrapper = StockScrapper()
    DATA['stock'] = scrapper.get_data(True)


def get_currency():
    global DATA
    scrapper = CurrencyScrapper()
    DATA['currency'] = scrapper.get_data(True)


def get_crypto():
    global DATA
    scrapper = CryptoScrapper()
    DATA['crypto'] = scrapper.get_data(True)


if __name__ == "__main__":
    app = tornado.web.Application([
        (r"/currency", CurrencyHandler),
        (r"/crypto", CryptoHandler),
        (r"/stock", StockHandler)
    ])

    server = tornado.httpserver.HTTPServer(app)
    server.bind(SERVER_PORT, address=SERVER_ADDRESS)
    server.start(0)

    cache_refresher = tornado.ioloop.PeriodicCallback(refresh_data, INTERVAL*1000)
    cache_refresher.start()

    refresh_data()

    try:
        tornado.ioloop.IOLoop.current().start()
    except KeyboardInterrupt:
        tornado.ioloop.IOLoop.current().stop()
        cache_refresher.stop()
